<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../config/db.php';
check_csrf();
$token = $_GET['token'] ?? '';
$stmt = $pdo->prepare("SELECT email FROM password_resets WHERE token=? AND expires_at > NOW()");
$stmt->execute([$token]);
$row = $stmt->fetch();
if (!$row) { die("Invalid or expired token."); }
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $pass = $_POST['password'] ?? '';
  if (strlen($pass)>=8) {
    $pdo->prepare("UPDATE users SET password=? WHERE email=?")->execute([password_hash($pass,PASSWORD_BCRYPT), $row['email']]);
    $pdo->prepare("DELETE FROM password_resets WHERE email=?")->execute([$row['email']]);
    flash('success','Password updated. Please login.');
    redirect('/public/login.php');
  } else { $err="Password must be at least 8 characters."; }
}
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
?>
<div class="container py-5" style="max-width:480px;">
  <h2 class="h4 mb-3">Reset Password</h2>
  <?php if(!empty($err)) echo '<div class="alert alert-danger">'.$err.'</div>'; ?>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="mb-3"><label class="form-label">New Password</label><input type="password" name="password" class="form-control" minlength="8" required></div>
    <button class="btn btn-primary">Update Password</button>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
