<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../lib/auth.php';
require __DIR__ . '/../config/db.php';
require_user();
$uid = $_SESSION['user']['id'];
$rows = $pdo->prepare("SELECT b.*, p.title FROM bookings b JOIN packages p ON p.id=b.package_id WHERE b.user_id=? ORDER BY b.id DESC");
$rows->execute([$uid]);
$rows = $rows->fetchAll();
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
$success = flash('success');
?>
<div class="container py-4">
  <h2 class="h4 mb-3">My Bookings</h2>
  <?php if($success) echo '<div class="alert alert-success">'.$success.'</div>'; ?>
  <div class="table-responsive">
    <table class="table table-striped">
      <thead><tr><th>ID</th><th>Package</th><th>Start</th><th>Travelers</th><th>Status</th></tr></thead>
      <tbody>
        <?php foreach($rows as $r): ?>
        <tr>
          <td><?php echo e($r['id']); ?></td>
          <td><?php echo e($r['title']); ?></td>
          <td><?php echo e($r['start_date']); ?></td>
          <td><?php echo e($r['travelers']); ?></td>
          <td><span class="badge bg-secondary"><?php echo e($r['status']); ?></span></td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
  <a class="btn btn-outline-secondary" href="/public/complaint.php">Generate Ticket (Complaint)</a>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
