<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../lib/mailer.php';
check_csrf();
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $email = trim($_POST['email'] ?? '');
  $stmt = $pdo->prepare("SELECT id FROM users WHERE email=?");
  $stmt->execute([$email]);
  if ($stmt->fetch()) {
    $token = bin2hex(random_bytes(16));
    $expires = date('Y-m-d H:i:s', time()+3600);
    $pdo->prepare("INSERT INTO password_resets(email,token,expires_at) VALUES(?,?,?)")->execute([$email,$token,$expires]);
    $link = "http://localhost/public/reset_password.php?token={$token}";
    send_mail($email, "Password Reset", "Click to reset your password: $link");
  }
  $info = "If the email exists, a reset link has been sent.";
}
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
?>
<div class="container py-5" style="max-width:480px;">
  <h2 class="h4 mb-3">Forgot Password</h2>
  <?php if(!empty($info)) echo '<div class="alert alert-info">'.$info.'</div>'; ?>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="mb-3"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
    <button class="btn btn-primary">Send Reset Link</button>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
