<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../lib/auth.php';
require __DIR__ . '/../config/db.php';
require_user();
check_csrf();

$pid = (int)($_GET['package_id'] ?? 0);
$pkg = $pdo->prepare("SELECT * FROM packages WHERE id=?"); $pkg->execute([$pid]); $pkg = $pkg->fetch();
if (!$pkg) { die("Package not found."); }

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $travelers = max(1, (int)($_POST['travelers'] ?? 1));
  $start = $_POST['start_date'] ?? '';
  $stmt = $pdo->prepare("INSERT INTO bookings(user_id,package_id,travelers,start_date) VALUES(?,?,?,?)");
  $stmt->execute([$_SESSION['user']['id'],$pid,$travelers,$start]);
  flash('success','Booking placed successfully.');
  redirect('/public/my_bookings.php');
}
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
?>
<div class="container py-5" style="max-width:680px;">
  <h2 class="h4 mb-3">Book: <?php echo e($pkg['title']); ?></h2>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="row g-3">
      <div class="col-md-6"><label class="form-label">Start Date</label><input type="date" name="start_date" class="form-control" required></div>
      <div class="col-md-6"><label class="form-label">Travelers</label><input type="number" name="travelers" min="1" class="form-control" value="1"></div>
    </div>
    <div class="mt-3 d-flex justify-content-between align-items-center">
      <div class="fw-bold">Total (approx): ₹<?php echo number_format($pkg['price'],2); ?></div>
      <button class="btn btn-primary">Confirm Booking</button>
    </div>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
