<?php
function redirect($path) {
  header("Location: " . $path);
  exit;
}
function e($str) { return htmlspecialchars((string)$str, ENT_QUOTES, 'UTF-8'); }
function csrf_token() {
  if (empty($_SESSION['csrf'])) { $_SESSION['csrf'] = bin2hex(random_bytes(32)); }
  return $_SESSION['csrf'];
}
function csrf_field() {
  return '<input type="hidden" name="csrf" value="'.e(csrf_token()).'">';
}
function check_csrf() {
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (empty($_POST['csrf']) || $_POST['csrf'] !== ($_SESSION['csrf'] ?? '')) {
      http_response_code(403); die("Invalid CSRF token.");
    }
  }
}
function flash($key, $message=null) {
  if (!isset($_SESSION)) { session_start(); }
  if ($message !== null) { $_SESSION['flash'][$key] = $message; return; }
  $msg = $_SESSION['flash'][$key] ?? null;
  if ($msg) unset($_SESSION['flash'][$key]);
  return $msg;
}
?>
