# Tourism Management System (PHP + MySQL)

Industrial-style starter with **User**, **Admin**, and **Guest** modules.

## Features
- User registration/login, forgot/reset password
- Tour packages (create/update/delete)
- Bookings (user places, admin manages)
- Issues/Tickets (user files complaint, admin closes)
- Inquiries (guest form, admin views)
- Static pages (About/Terms/Privacy)
- CSRF protection, password hashing, PDO prepared statements
- Bootstrap 5 professional UI (landing page, navbar, footer)

## Quick Setup
1. Create MySQL DB (default `tms_php`) and update `config/config.php` credentials.
2. Serve `/public` and `/admin` via PHP server (e.g., Apache/Nginx). For built-in server:
   ```bash
   php -S localhost:8000 -t public
   ```
   Admin can be accessed at `/admin` separately:
   ```bash
   php -S localhost:8001 -t admin
   ```
3. Set admin credentials in `config/constants.php` (`ADMIN_EMAIL`, `ADMIN_PASSWORD`).
4. Run seeder (creates tables, admin, and sample data):
   ```bash
   php seed.php
   ```

## Default Admin
- Email: value from `config/constants.php` (default `admin@example.com`)
- Password: value from `config/constants.php` (default `Admin@12345`)

## Notes
- Emails are logged to `storage/mail.log` (no SMTP required). Replace `lib/mailer.php` with a real mailer for production.
- Images are placeholders in `public/assets/images`. Replace with real assets.
- Use HTTPS, strong passwords, and production-grade config before going live.
