<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();
check_csrf();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $name = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $pass = $_POST['password'] ?? '';
  if ($name && filter_var($email,FILTER_VALIDATE_EMAIL) && strlen($pass)>=8) {
    $stmt = $pdo->prepare("INSERT INTO users(name,email,password) VALUES(?,?,?)");
    try {
      $stmt->execute([$name,$email,password_hash($pass, PASSWORD_BCRYPT)]);
      flash('success','Registration successful. Please login.');
      redirect('/public/login.php');
    } catch (Exception $e) { $err="Email already in use."; }
  } else { $err="Invalid data or weak password."; }
}
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
?>
<div class="container py-5" style="max-width:520px;">
  <h2 class="h4 mb-3">Create Account</h2>
  <?php if(!empty($err)) echo '<div class="alert alert-danger">'.$err.'</div>'; ?>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="mb-3"><label class="form-label">Name</label><input name="name" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">Password</label><input type="password" name="password" class="form-control" minlength="8" required></div>
    <button class="btn btn-primary w-100">Register</button>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
