<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../config/db.php';
if (session_status() === PHP_SESSION_NONE) session_start();
check_csrf();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $email = trim($_POST['email'] ?? '');
  $pass = $_POST['password'] ?? '';
  $stmt = $pdo->prepare("SELECT * FROM users WHERE email=? AND role='user'");
  $stmt->execute([$email]);
  $u = $stmt->fetch();
  if ($u && password_verify($pass, $u['password'])) {
    $_SESSION['user'] = ['id'=>$u['id'], 'name'=>$u['name'], 'email'=>$u['email']];
    redirect('/public/index.php');
  } else { $err="Invalid credentials."; }
}
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
$success = flash('success');
?>
<div class="container py-5" style="max-width:480px;">
  <?php if($success) echo '<div class="alert alert-success">'.$success.'</div>'; ?>
  <?php if(!empty($err)) echo '<div class="alert alert-danger">'.$err.'</div>'; ?>
  <h2 class="h4 mb-3">Login</h2>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="mb-3"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
    <div class="mb-3"><label class="form-label">Password</label><input type="password" name="password" class="form-control" required></div>
    <div class="d-flex justify-content-between">
      <a href="/public/forgot_password.php">Forgot Password?</a>
      <button class="btn btn-primary">Login</button>
    </div>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
