<?php
require __DIR__ . '/../lib/helpers.php';
require __DIR__ . '/../config/db.php';
require __DIR__ . '/../lib/mailer.php';
check_csrf();
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $name = trim($_POST['name'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $message = trim($_POST['message'] ?? '');
  if ($name && filter_var($email,FILTER_VALIDATE_EMAIL) && $message) {
    $pdo->prepare("INSERT INTO inquiries(name,email,message) VALUES(?,?,?)")->execute([$name,$email,$message]);
    send_mail($email, "We received your enquiry", "Thanks $name, we will get back soon.");
    $ok = true;
  } else { $err="Please fill all fields correctly."; }
}
include __DIR__ . '/partials/header.php'; include __DIR__ . '/partials/navbar.php';
?>
<div class="container py-5" style="max-width:680px;">
  <h2 class="h4 mb-3">General Enquiry</h2>
  <?php if(!empty($ok)) echo '<div class="alert alert-success">Thank you! We will contact you shortly.</div>'; ?>
  <?php if(!empty($err)) echo '<div class="alert alert-danger">'.$err.'</div>'; ?>
  <form method="post">
    <?php echo csrf_field(); ?>
    <div class="mb-3"><label class="form-label">Name</label><input class="form-control" name="name" required></div>
    <div class="mb-3"><label class="form-label">Email</label><input type="email" class="form-control" name="email" required></div>
    <div class="mb-3"><label class="form-label">Message</label><textarea class="form-control" rows="5" name="message" required></textarea></div>
    <button class="btn btn-primary">Submit</button>
  </form>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
