<?php
require __DIR__ . '/../lib/auth.php'; require_admin();
require __DIR__ . '/../config/db.php'; require __DIR__ . '/../lib/helpers.php';
check_csrf();
$action = $_GET['action'] ?? '';
if ($action==='save' && $_SERVER['REQUEST_METHOD']==='POST') {
  $slug = trim($_POST['slug']);
  $title = trim($_POST['title']);
  $content = $_POST['content'];
  $pdo->prepare("INSERT INTO pages(slug,title,content) VALUES(?,?,?) ON DUPLICATE KEY UPDATE title=VALUES(title), content=VALUES(content)")
      ->execute([$slug,$title,$content]);
  flash('ok','Page saved.');
  redirect('/admin/pages.php');
}
$rows = $pdo->query("SELECT * FROM pages ORDER BY id DESC")->fetchAll();
include __DIR__ . '/partials/header.php';
$ok = flash('ok');
?>
<h3 class="mb-3">Manage Pages</h3>
<?php if($ok) echo '<div class="alert alert-success">'.$ok.'</div>'; ?>
<div class="card mb-3"><div class="card-body">
  <form method="post" action="/admin/pages.php?action=save">
    <?php echo csrf_field(); ?>
    <div class="row g-2">
      <div class="col-md-3"><input class="form-control" name="slug" placeholder="Slug (about, terms)" required></div>
      <div class="col-md-4"><input class="form-control" name="title" placeholder="Title" required></div>
      <div class="col-md-5"><input class="form-control" name="content" placeholder="HTML content" required></div>
    </div>
    <div class="mt-2 text-end"><button class="btn btn-dark btn-sm">Save Page</button></div>
  </form>
</div></div>
<div class="table-responsive">
<table class="table table-striped"><thead><tr><th>ID</th><th>Slug</th><th>Title</th><th>Updated</th></tr></thead>
<tbody><?php foreach($rows as $r): ?><tr>
  <td><?php echo $r['id']; ?></td><td><?php echo e($r['slug']); ?></td><td><?php echo e($r['title']); ?></td><td><?php echo e($r['updated_at']); ?></td>
</tr><?php endforeach; ?></tbody>
</table>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
