<?php
require __DIR__ . '/../lib/auth.php'; require_admin();
require __DIR__ . '/../lib/helpers.php'; require __DIR__ . '/../config/db.php';
check_csrf();

$action = $_GET['action'] ?? '';
if ($action==='create' && $_SERVER['REQUEST_METHOD']==='POST') {
  $stmt=$pdo->prepare("INSERT INTO packages(category_id,title,description,price,duration_days) VALUES(?,?,?,?,?)");
  $stmt->execute([$_POST['category_id'] ?: null, $_POST['title'], $_POST['description'], $_POST['price'], $_POST['duration_days']]);
  flash('ok','Package created.');
  redirect('/admin/packages.php');
}
if ($action==='update' && $_SERVER['REQUEST_METHOD']==='POST') {
  $stmt=$pdo->prepare("UPDATE packages SET category_id=?, title=?, description=?, price=?, duration_days=? WHERE id=?");
  $stmt->execute([$_POST['category_id'] ?: null, $_POST['title'], $_POST['description'], $_POST['price'], $_POST['duration_days'], $_POST['id']]);
  flash('ok','Package updated.');
  redirect('/admin/packages.php');
}
if ($action==='delete') {
  $pdo->prepare("DELETE FROM packages WHERE id=?")->execute([$_GET['id'] ?? 0]);
  flash('ok','Package deleted.');
  redirect('/admin/packages.php');
}
$cats = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll();
$rows = $pdo->query("SELECT p.*, c.name as category FROM packages p LEFT JOIN categories c ON c.id=p.category_id ORDER BY p.id DESC")->fetchAll();
include __DIR__ . '/partials/header.php';
$ok = flash('ok');
?>
<h3 class="mb-3">Manage Packages</h3>
<?php if($ok) echo '<div class="alert alert-success">'.$ok.'</div>'; ?>
<div class="card mb-4"><div class="card-body">
  <form method="post" action="/admin/packages.php?action=create">
    <?php echo csrf_field(); ?>
    <div class="row g-2">
      <div class="col-md-3"><input class="form-control" name="title" placeholder="Title" required></div>
      <div class="col-md-3"><input class="form-control" name="description" placeholder="Short description" required></div>
      <div class="col-md-2"><input class="form-control" name="price" type="number" step="0.01" placeholder="Price" required></div>
      <div class="col-md-2"><input class="form-control" name="duration_days" type="number" placeholder="Days" required></div>
      <div class="col-md-2">
        <select class="form-select" name="category_id">
          <option value="">Category</option>
          <?php foreach($cats as $c): ?><option value="<?php echo $c['id']; ?>"><?php echo e($c['name']); ?></option><?php endforeach; ?>
        </select>
      </div>
    </div>
    <div class="mt-2 text-end"><button class="btn btn-dark btn-sm">Add Package</button></div>
  </form>
</div></div>

<div class="table-responsive">
<table class="table table-striped align-middle">
  <thead><tr><th>ID</th><th>Title</th><th>Category</th><th>Price</th><th>Days</th><th>Action</th></tr></thead>
  <tbody>
  <?php foreach($rows as $r): ?>
    <tr>
      <td><?php echo e($r['id']); ?></td>
      <td><?php echo e($r['title']); ?></td>
      <td><?php echo e($r['category']); ?></td>
      <td>₹<?php echo number_format($r['price'],2); ?></td>
      <td><?php echo e($r['duration_days']); ?></td>
      <td>
        <form class="d-inline" method="post" action="/admin/packages.php?action=update">
          <?php echo csrf_field(); ?>
          <input type="hidden" name="id" value="<?php echo e($r['id']); ?>">
          <input type="hidden" name="title" value="<?php echo e($r['title']); ?>">
          <input type="hidden" name="description" value="<?php echo e($r['description']); ?>">
          <input type="hidden" name="price" value="<?php echo e($r['price']); ?>">
          <input type="hidden" name="duration_days" value="<?php echo e($r['duration_days']); ?>">
          <input type="hidden" name="category_id" value="<?php echo e($r['category_id']); ?>">
          <button class="btn btn-sm btn-outline-primary">Quick Save</button>
        </form>
        <a class="btn btn-sm btn-outline-danger" href="/admin/packages.php?action=delete&id=<?php echo e($r['id']); ?>" onclick="return confirm('Delete?')">Delete</a>
      </td>
    </tr>
  <?php endforeach; ?>
  </tbody>
</table>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
