<?php
require __DIR__ . '/../lib/auth.php'; require_admin();
require __DIR__ . '/../config/db.php'; require __DIR__ . '/../lib/helpers.php';
if (($_GET['action'] ?? '')==='close') {
  $pdo->prepare("UPDATE issues SET status='closed' WHERE id=?")->execute([$_GET['id'] ?? 0]);
  flash('ok','Issue closed.');
  header("Location: /admin/issues.php"); exit;
}
$ok=flash('ok');
include __DIR__ . '/partials/header.php';
$rows = $pdo->query("SELECT i.*, u.name FROM issues i JOIN users u ON u.id=i.user_id ORDER BY i.id DESC")->fetchAll();
?>
<h3 class="mb-3">Manage Issues</h3>
<?php if($ok) echo '<div class="alert alert-success">'.$ok.'</div>'; ?>
<div class="table-responsive">
<table class="table table-striped">
  <thead><tr><th>ID</th><th>User</th><th>Subject</th><th>Status</th><th>Action</th></tr></thead>
  <tbody><?php foreach($rows as $r): ?><tr>
    <td><?php echo $r['id']; ?></td><td><?php echo e($r['name']); ?></td><td><?php echo e($r['subject']); ?></td>
    <td><?php echo e($r['status']); ?></td>
    <td><?php if($r['status']=='open'): ?><a class="btn btn-sm btn-outline-success" href="/admin/issues.php?action=close&id=<?php echo $r['id']; ?>">Close</a><?php endif; ?></td>
  </tr><?php endforeach; ?></tbody>
</table>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
