<?php
require __DIR__ . '/../lib/auth.php';
require_admin();
require __DIR__ . '/../config/db.php';
$stats = [
  'users' => $pdo->query("SELECT COUNT(*) FROM users WHERE role='user'")->fetchColumn(),
  'packages' => $pdo->query("SELECT COUNT(*) FROM packages")->fetchColumn(),
  'bookings' => $pdo->query("SELECT COUNT(*) FROM bookings")->fetchColumn(),
  'inquiries' => $pdo->query("SELECT COUNT(*) FROM inquiries")->fetchColumn(),
];
include __DIR__ . '/partials/header.php';
?>
<h3 class="mb-4">Dashboard</h3>
<div class="row g-3">
  <?php foreach($stats as $k=>$v): ?>
  <div class="col-md-6">
    <div class="card shadow-sm">
      <div class="card-body d-flex justify-content-between align-items-center">
        <div class="text-capitalize fw-bold"><?php echo e($k); ?></div>
        <div class="display-6"><?php echo e($v); ?></div>
      </div>
    </div>
  </div>
  <?php endforeach; ?>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
